<?php

namespace App\Http\Controllers;

use App\Events\AntrianEvent;
use App\Http\Requests\PasienBpjsRequest;
use App\Http\Requests\PasienUmumRequest;
use App\Http\Controllers\Api\Wsrs\AmbilAntrian;
use App\Models\JadwalPoli;
use App\Models\Kabupaten;
use App\Models\Kecamatan;
use App\Models\Kelurahan;
use App\Models\Propinsi;
use App\Models\SMIS_Pasien;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Mjkn_Patient;
use App\Helpers\GeneralHelper as GH;
use GuzzleHttp\Client;
use App\Models\SMIS_LayananPasien;
use App\Models\RsCredential;
use App\Models\Antrian;
use App\Models\JenisPasien;
use App\Models\SMIS_Rg_Asuransi;
use App\Models\SMIS_Rg_Perusahaan;
use App\Models\SmisHrdEmployee;
use App\Services\AntrianPendaftaranService;
use App\Services\AntrianManualService;
use App\Services\SmisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class GuestRegistrationController extends Controller
{
    function send_broadcast(Request $req, AntrianManualService $ams)
    {
        $poli = $req->poli ? $req->poli : '';
        $baru = $req->baru == 1 ? 1 : 0;

        if ($req->manual == '1') {
            $last = $ams->getLastAntrian();
            if ($req->tipe == 'next') {
                if ($last->last_queue == $last->last_call) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Sudah antrian terakhir.'
                    ]);
                }
                event(new AntrianEvent($req->loket, ($last->last_call + 1), $req->bagian, $req->pasien, $poli, $req->lantai, $baru, $req->manual));
                $ams->next($req->all());
                return response()->json([
                    'status' => true,
                    'message' => 'Ok.',
                    'data' => $ams->getLastAntrian()
                ]);
            } else {
                event(new AntrianEvent($req->loket, $last->last_call, $req->bagian, $req->pasien, $poli, $req->lantai, $baru, $req->manual));
                return response()->json([
                    'status' => true,
                    'message' => 'Ok.'
                ]);
            }
        } else {
            $antrian = DB::table('antrians')->leftJoin('smis_rg_jadwalpoli', 'smis_rg_jadwalpoli.id', 'antrians.jadwal_id')
            ->where('taskid', '<=', 3)
            ->where('nomorantrean', $req->nomor)
            ->where('smis_rg_jadwalpoli.id', $req->id_jadwal)
            ->where('unit_kerja', env('NAMA_KLINIK'))
            ->where('tanggalperiksa', date('Y-m-d'))
            ->select('antrians.unit_kerja', 'smis_rg_jadwalpoli.poli_ke')
            ->first();
            
            event(new AntrianEvent($req->loket, $req->nomor, $req->bagian, $req->pasien, $antrian, $req->lantai, $baru, $req->manual));

            return response()->json([
                'status' => true,
                'message' => 'Ok.'
            ]);
        }
    }

    function cetak_antrian(Request $req)
    {
        $data['data'] = Antrian::leftJoin('smis_rg_patient', 'smis_rg_patient.id', 'antrians.id_pasien')
            ->join('smis_rg_jadwalpoli', 'smis_rg_jadwalpoli.id', 'antrians.jadwal_id')
            ->select('antrians.*', 'smis_rg_patient.nama as pasien')
            ->where('smis_rg_patient.prop', '')->where('smis_rg_jadwalpoli.prop', '')->where('antrians.id', $req->antrian)->first();
        return view('guest.cetak_antrian', $data);
    }

    function index()
    {
        return view('guest.home');
    }

    function umum()
    {
        $data['propinsi'] = Propinsi::all();
        return view('guest.umum', $data);
    }

    function bpjs()
    {
        $data['propinsi'] = Propinsi::all();
        return view('guest.bpjs', $data);
    }

    function ajax_request_kabupaten(Request $req)
    {
        return response()->json(Kabupaten::where('no_prop', $req->propinsi)->get());
    }

    function ajax_request_kecamatan(Request $req)
    {
        return response()->json(Kecamatan::where('no_kab', $req->kabupaten)->get());
    }

    function ajax_request_kelurahan(Request $req)
    {
        return response()->json(Kelurahan::where('no_kec', $req->kecamatan)->get());
    }

    function ajax_request_pasien(Request $req, SmisService $ss)
    {
        // $hit_service = $ss->post(env('SMIS_URL_GET_PESERTA_BY_KTP'), [
        //     [
        //         'name'     => 'username',
        //         'contents' => Auth::user()->username
        //     ],
        //     [
        //         'name'     => 'ktp',
        //         'contents' => $req->nomor
        //     ]
        // ]);

        // if ($hit_service->getStatusCode() != 200) {
        //     return response()->json([
        //         'status' => false,
        //         'message' => $hit_service->getReasonPhrase(),
        //         'data' => null
        //     ]);
        // }

        // $data = json_decode($hit_service->getBody()->getContents());

        // if (is_null($data)) {
        //     return response()->json([
        //         'status' => false,
        //         'message' => 'Pasien tidak ditemukan',
        //         'data' => null
        //     ]);
        // }

        // if (is_null($data->response)) {
        //     return response()->json([
        //         'status' => false,
        //         'message' => 'Pasien tidak ditemukan',
        //         'data' => null
        //     ]);
        // }else{
        //     if ($data->response->ketAktif != 'AKTIF') {
        //         return response()->json([
        //             'status' => false,
        //             'message' => 'Pasien tidak aktif, tidak dapat mengambil antrian',
        //             'data' => null
        //         ]);
        //     }
        // }
        $data = SMIS_Pasien::where('prop', '')->where('ktp', $req->nomor)->where('id', 'like', '%' . env('slug_klinik') . '%')->first();

        if (is_null($data)) {
            $data = SMIS_Pasien::where('prop', '')->where('nrm', $req->nomor)->where('id', 'like', '%' . env('slug_klinik') . '%')->first();
        }

        return response()->json([
            'status' => true,
            'message' => 'Ok',
            'data' => $data
        ]);
    }

    function ajax_request_pasien_bpjs(Request $req, SmisService $ss)
    {

        if (strlen($req->nomor) == '13') {
            $hit_service = $ss->post(env('SMIS_URL_GET_PESERTA_BY_BPJS'), [
                [
                    'name'     => 'username',
                    'contents' => Auth::user()->username
                ],
                [
                    'name'     => 'no_bpjs',
                    'contents' => $req->nomor
                ]
            ]);
        } else if (strlen($req->nomor) == '16') {
            $hit_service = $ss->post(env('SMIS_URL_GET_PESERTA_BY_KTP'), [
                [
                    'name'     => 'username',
                    'contents' => Auth::user()->username
                ],
                [
                    'name'     => 'ktp',
                    'contents' => $req->nomor
                ]
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Identitas tidak sesuai',
                'data' => null,
                'pasien_pcare' => null
            ]);
        }

        if ($hit_service->getStatusCode() != 200) {
            return response()->json([
                'status' => false,
                'message' => $hit_service->getReasonPhrase(),
                'data' => null
            ]);
        }

        $data = json_decode($hit_service->getBody()->getContents());

        if (is_null($data)) {
            return response()->json([
                'status' => false,
                'message' => 'Pasien tidak ditemukan',
                'data' => null
            ]);
        }

        if (is_null($data->response)) {
            return response()->json([
                'status' => false,
                'message' => 'Pasien tidak ditemukan',
                'data' => null
            ]);
        }
        
        if ($data->response->ketAktif != 'AKTIF') {
            return response()->json([
                'status' => false,
                'message' => 'Pasien tidak aktif, tidak dapat mengambil antrian',
                'data' => null
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Ok',
            'data' => SMIS_Pasien::where('prop', '')->where(function ($q) use ($req) {
                $q->where('ktp', $req->nomor)->orWhere('nobpjs', $req->nomor);
            })->where('id', 'like', '%' . env('slug_klinik') . '%')->first(),
            'pasien_pcare' => $data ? $data->response : null
        ]);
    }

    function daftar_pasien_umum(Request $req)
    {
        $data['pasien'] = SMIS_Pasien::findOrFail($req->pasien);
        // if ($data['pasien']->telpon == '') {
        //     return redirect()->back()->with('gagal', 'Pasien tidak dapat didaftarkan karena belum mengisi no telepon');
        // }
        $data['poli'] = JadwalPoli::select('kodepoli_bpjs', 'nama_poli_pcare')->where('slug_poli', 'like', '%' . env('slug_klinik') . '%')->whereBetween('hari', [date('w'), (date('w', strtotime('+1 days')) == 0 ? 7 : date('w', strtotime('+1 days')))])->groupBy(['kodepoli_bpjs', 'nama_poli_pcare'])->get();
        $data['jenispasien'] = JenisPasien::where('prop', '')->get();
        $data['asuransi'] = SMIS_Rg_Asuransi::where('prop', '')->get();
        $data['perusahaan'] = SMIS_Rg_Perusahaan::where('prop', '')->get();
        return view('guest/pasien_umum_daftar', $data);
    }

    function daftar_pasien_bpjs(Request $req)
    {
        $data['pasien'] = SMIS_Pasien::findOrFail($req->pasien);
        // if ($data['pasien']->telpon == '') {
        //     return redirect()->back()->with('gagal', 'Pasien tidak dapat didaftarkan karena belum mengisi no telepon');
        // }
        $data['poli'] = JadwalPoli::select('kodepoli_bpjs', 'nama_poli_pcare')->where('slug_poli', 'like', '%' . env('slug_klinik') . '%')->whereBetween('hari', [date('w'), (date('w', strtotime('+1 days')) == 0 ? 7 : date('w', strtotime('+1 days')))])->groupBy(['kodepoli_bpjs', 'nama_poli_pcare'])->get();
        $data['jenispasien'] = JenisPasien::where('prop', '')->get();
        $data['asuransi'] = SMIS_Rg_Asuransi::where('prop', '')->get();
        $data['perusahaan'] = SMIS_Rg_Perusahaan::where('prop', '')->get();
        return view('guest/pasien_bpjs_daftar', $data);
    }

    function ajax_request_dokter_by_poli(Request $req)
    {
        $temp = explode('-', $req->kode);
        $data = JadwalPoli::where('slug_poli', 'like', '%' . env('slug_klinik') . '%')->where('kodepoli_bpjs', $temp[0])
            ->where('nama_poli_pcare', $temp[1])->where('hari', ($req->hari == 0 ? 7 : $req->hari))
            ->where('jam_mulai', '<=', date('H:i'))
            ->where('jam_selesai', '>=', date('H:i'))
            ->where('prop', '')
            ->select('id', 'id_dokter', 'nama_dokter', 'jam_mulai', 'jam_selesai')->get();
        return response()->json($data);
    }

    function ajax_request_jam_praktek_by_dokter(Request $req)
    {
        $data = JadwalPoli::where('id_dokter', 'like', $req->dokter)->where('hari', ($req->hari == 0 ? 7 : $req->hari))->where('prop','')->get();
        return response()->json($data);
    }

    function tambah_pasien(PasienUmumRequest $req, AntrianPendaftaranService $aps)
    {
        try {
            $mjkn = $aps->insert_pasien_anjungan_mandiri($req);
            $employee = SmisHrdEmployee::where('usname', Auth::user()->username)->where('prop', '')->first();
            $faskes = DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->first();

            DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->update([
                'last_nrm' => $mjkn['nrm']
            ]);

            DB::table('smis_rg_history_nrm')->insert([
                'id_rg_patient' => $mjkn['id'],
                'operator' => Auth::user()->username,
                'waktu' => date('Y-m-d H:i:s'),
                'deskripsi' => 'LARAVEL PASIEN BARU',
                'nrm_asal' => $faskes->last_nrm,
                'nrm_baru' => $mjkn['nrm'],
                'unit' => $employee ? $employee->unit_kerja : ''
            ]);

            return redirect('guest_registration/pasien_umum')->with('sukses', 'Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di ' . env('NAMA_KLINIK'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function tambah_pasien_bpjs(PasienBpjsRequest $req, AntrianPendaftaranService $aps)
    {
        try {
            $mjkn = $aps->insert_pasien_anjungan_mandiri($req);
            $employee = SmisHrdEmployee::where('usname', Auth::user()->username)->where('prop', '')->first();
            $faskes = DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->first();

            DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->update([
                'last_nrm' => $mjkn['nrm']
            ]);

            DB::table('smis_rg_history_nrm')->insert([
                'id_rg_patient' => $mjkn['id'],
                'operator' => Auth::user()->username,
                'waktu' => date('Y-m-d H:i:s'),
                'deskripsi' => 'LARAVEL PASIEN BARU',
                'nrm_asal' => $faskes->last_nrm,
                'nrm_baru' => $mjkn['nrm'],
                'unit' => $employee ? $employee->unit_kerja : ''
            ]);

            return redirect('guest_registration/pasien_bpjs')->with('sukses', 'Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di ' . env('NAMA_KLINIK'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function post_bpjs($url, $data)
    {
        $credentials = RsCredential::where('layanan', 'antrian')->where('slug_klinik', env('slug_klinik'))->first();
        // return response()->json($credentials);
        if ($credentials == null) {
            return [
                'status' => false,
                'message' => 'Credential RS tidak ditemukan'
            ];
        }
        try {
            date_default_timezone_set('UTC');
            $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));
            $signature = $this->get_signature($timeStamp, $credentials->cons_id, $credentials->cons_secret);
            $guzzleClient = new Client([
                'verify' => false
            ]);
            $response = $guzzleClient->request('post', $credentials->base_url . '/' . $url, [
                'headers' => [
                    'x-cons-id'     => $credentials->cons_id,
                    'x-timestamp'  => $timeStamp,
                    'x-signature'   => $signature,
                    'user_key' => $credentials->user_key,
                ],
                'body' => $data
            ]);

            if ($response->getStatusCode() == 200) {
                $list = json_decode($response->getBody()->getContents());
                if ($list->metadata->code == 201) {
                    return [
                        'status' => true,
                        'message' => $list->metadata->message,
                        'code' => $list->metadata->code
                    ];
                }
                return [
                    'status' => true,
                    'message' => $list->metadata->message,
                    'code' => $list->metadata->code
                ];
            } else {
                return [
                    'status' => false,
                    'message' => 'Gagal terhubung ke bpjs',
                    'code' => $response->getStatusCode()
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ];
        }
    }

    function pasien_umum_daftar_post(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'tanggalperiksa' => "required|date_format:Y-m-d",
            'kodepoli' => 'required',
            'kodedokter' => 'required',
            'jampraktek' => 'required',
            'jenis_kunjungan' => "required"
        ], [
            'tanggalperiksa.required' => 'Pilih tanggal periksa dahulu',
            'tanggalperiksa.date_format' => 'Format tanggal periksa tidak sesuai',
            'kodepoli.required' => 'Pilih poli dahulu',
            'kodedokter.required' => 'Pilih dokter dahulu',
            'jampraktek.required' => 'Pilih jam terlebih dahulu',
            'jenis_kunjungan.required' => 'Jenis kunjungan harus diisi'
        ]);

        $valid = $this->valid($req->all());
        if ($valid['metadata']['code'] != "200") return redirect()->back()->with('gagal', $valid['metadata']['message']);

        // dd($valid);

        $poli = explode('-', $req['kodepoli']);
        // data antrian
        $jadwal = $valid['response']['jadwal'];
        $pasien = $valid['response']['pasien'];

        // if ($pasien->origin_updated == 'mobile-jkn') {
        //     return redirect()->back()->with('gagal', 'No. rekam medis anda ' . $pasien['id'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di RSI Jombang');
        // }

        $sisakuota = $valid['response']['sisakuota'];
        $generate = GH::generateAntrean($jadwal['kodedokter_bpjs'], $jadwal['id'], $poli[0], $req->tanggalperiksa);
        $mili = strtotime($req->tanggalperiksa . ' ' . $jadwal->jam_mulai);
        $estimasi = ($mili * 1000) + (($generate['angkaantrean'] - 1) * ($jadwal->estimasi_layanan * 60000));

        $count_baru_lama = SMIS_LayananPasien::where('nrm', $pasien['id'])->count();

        $antrian = new Antrian();
        if ($count_baru_lama > 0) {
            $antrian->pasien_baru = 0;
        } else {
            $antrian->pasien_baru = 1;
        }
        // $antriran->pasien_baru = $count_baru_lama > 0 ? '0' : '1';

        $jp = $req->jenis_pasien ? explode('-', $req->jenis_pasien) : [''];

        $antrian->jenis_kunjungan = $req->jenis_kunjungan ? $req->jenis_kunjungan : '';
        $antrian->nobpjs = $pasien->nobpjs;
        $antrian->taskid = 0;
        $antrian->tanggalperiksa = $req->tanggalperiksa;
        $antrian->jadwal_id = $jadwal['id'];
        $antrian->carabayar = $jp[0] ? $jp[0] : '';
        $antrian->asuransi = isset($req->asuransi) ? $req->asuransi : 0;
        $antrian->perusahaan = isset($req->perusahaan) ? $req->perusahaan : 0;
        $antrian->nomorantrean = $generate['nomorantrean'];
        $antrian->angkaantrean = $generate['angkaantrean'];
        $antrian->norm = $pasien['nrm'];
        $antrian->nama_pasien = $pasien['nama'];
        $antrian->id_pasien = $pasien['id'];
        $antrian->namapoli = $jadwal['nama_poli'];
        $antrian->namadokter = $jadwal['nama_dokter'];
        $antrian->estimasidilayani = $estimasi; // masih salah harus di ganti
        $antrian->created_at = date('Y-m-d H:i:s');
        $antrian->updated_at = date('Y-m-d H:i:s');
        $antrian->sisakuota = $sisakuota;
        $antrian->kuota = $jadwal['kuota'];
        $antrian->keterangan = 'Peserta harap 60 menit lebih awal guna pencatatan administrasi.';
        $antrian->unit_kerja = env('NAMA_KLINIK');
        $antrian->keluhan = $req->keluhan ? $req->keluhan : '-';

        $ref = $req->nomorreferensi ? $req->nomorreferensi : '';

        // if (isset($req->nobpjs)) {
        //     if ($req->nomorreferensi == '-' || $req->nomorreferensi == '') {
        //         return redirect()->back()->with('gagal', 'Nomor referensi belum sesuai');
        //     }
        //     if (strlen($req->nomorreferensi) < 19) {
        //         return redirect()->back()->with('gagal', 'Nomor referensi belum sesuai');
        //     }
        // }

        try {
            if ($req->form == 'bpjs') {
                $param_antrian_bpjs = json_encode([
                    // 'kodebooking' => $generate['kodebooking'],
                    // 'jenispasien' => $req->nobpjs ? 'JKN' : 'NON JKN',
                    'nomorkartu' => $req->form == 'bpjs' ? $req->nobpjs ? $req->nobpjs : '' : '',
                    'nik' => $pasien['ktp'],
                    'nohp' => $pasien['telpon'],
                    'kodepoli' => $jadwal['kodepoli_bpjs'],
                    'namapoli' => $jadwal['nama_poli'],
                    // 'pasienbaru' => $antrian->pasien_baru,
                    'norm' => $pasien['nrm'],
                    'tanggalperiksa' => $antrian->tanggalperiksa,
                    'kodedokter' => (int)$jadwal['kodedokter_bpjs'],
                    'namadokter' => $jadwal['nama_dokter'],
                    'jampraktek' => $jadwal['jam_mulai'] . '-' . $jadwal['jam_selesai'],
                    // 'jeniskunjungan' => (int)$req->jenis_kunjungan,
                    // 'nomorreferensi' => $ref,
                    'nomorantrean' => $generate['nomorantrean'],
                    'angkaantrean' => $generate['angkaantrean'],
                    // 'estimasidilayani' => $estimasi,
                    // "sisakuotajkn" => $sisakuotajkn,
                    // "kuotajkn" => $jadwal['kuota_jkn'],
                    // "sisakuotanonjkn" => $sisakuotanonjkn,
                    // "kuotanonjkn" => $jadwal['kuota_non_jkn'],
                    "keterangan" => $antrian->keterangan
                ]);


                $result = $this->post_bpjs('antrean/add', $param_antrian_bpjs);
                
                if ($result['status']) {
                    if ($result['code'] != 200) {
                        return redirect()->back()->with('gagal', $result['message']);
                    }
                    $antrian->response_code = 200;
                    $antrian->response_message = 'Ok';
                    $antrian->save();
                    $last_insert = Antrian::orderBy('id', 'desc')->first();
                    return redirect('guest_registration/hasil_antrian?antrian=' . $last_insert->id);
                } else {
                    return redirect()->back()->with('gagal', $result['message']);
                }
            }

            $antrian->response_code = 200;
            $antrian->response_message = 'Ok';
            $antrian->save();
            $last_insert = Antrian::orderBy('id', 'desc')->first();
            return redirect('guest_registration/hasil_antrian?antrian=' . $last_insert->id);
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function hasil(Request $req)
    {
        $antrian = Antrian::findOrFail($req->antrian);
        $data['pasien'] = SMIS_Pasien::where('nrm', $antrian->norm)->first();
        $data['antrian'] = $antrian;
        $data['nomorantrian'] = $antrian->nomorantrean;
        $data['estimasi'] = $antrian->estimasidilayani;
        return view('guest.hasil', $data);
    }

    function get_signature($timeStamp, $cons_id, $cons_secret)
    {
        $signature = hash_hmac('sha256', $cons_id . "&" . $timeStamp, $cons_secret, true);
        $encodedSignature = base64_encode($signature);
        return $encodedSignature;
    }

    private function valid($param)
    {
        $pasien = SMIS_Pasien::where('prop', '')->findOrFail($param['pasien']);
        $poli = explode('-', $param['kodepoli']);
        $jadwal = new JadwalPoli();

        // jika poli tidak ada
        $jadwal = $jadwal->where("kodepoli_bpjs", $poli[0]);
        if (is_null($jadwal->first())) {
            return $this->responseFormat("Poli tidak ditemukan.", 201);
        }
        // jika dokter tidak ada
        $dokter = explode('-', $param['kodedokter']);
        $jadwal = $jadwal->where("id_dokter", $dokter[0])->where('id', $dokter[1]);

        if (is_null($jadwal->first())) {
            return $this->responseFormat("Dokter di Poli ini tidak ditemukan.", 201);
        }
        // jika format tanggal salah
        $checkTgl = Validator::make(["tanggalperiksa" => $param['tanggalperiksa']], [
            'tanggalperiksa' => 'date_format:Y-m-d',
        ]);
        if ($checkTgl->fails()) {
            return $this->responseFormat("Format tanggal salah gunakan format Y-m-d.", 201);
        }
        // jika tanggal telah berlalu
        if (date("Y-m-d") > $param['tanggalperiksa']) {
            return $this->responseFormat("Tanggal periksa yang anda masukkan telah berlalu.", 201);
        }

        // tidak bisa ambil antrian di hari H
        // if (date("Y-m-d") == $param['tanggalperiksa']) {
        //     return $this->responseFormat("Anda tidak dapat mengambil antrian di hari H.", 201);
        // }
        // jika format jam praktek salah
        // $jampraktek = explode("-", $param['jampraktek']);
        // if (count($jampraktek) < 2 || ($jampraktek[0] == "" && $jampraktek[1] == ""))
        //     return $this->responseFormat("Format jam praktek salah, contoh yang benar: 08:00-10:00", 201);

        // jika jadwal tidak ada
        $hari = date("N", strtotime($param['tanggalperiksa']));
        $jadwal = $jadwal->where("hari", $hari)->where('prop', '');
        // $jadwal = $jadwal->where("jam_mulai", $jampraktek[0]);
        // $jadwal = $jadwal->where("jam_selesai", $jampraktek[1])->first();
        if (is_null($jadwal)) {
            return $this->responseFormat("Jadwal tidak ditemukan.", 201);
        }

        $jadwal = $jadwal->first();

        $sekarang = strtotime('now');
        $str_jadwal = strtotime($param['tanggalperiksa'] . ' ' . $jadwal->jam_selesai);

        if ($sekarang > $str_jadwal) {
            return $this->responseFormat("Pendaftaran ke poli " . $poli[1] . " sudah tutup jam " . $jadwal->jam_selesai, 201);
        }

        // dd($param);

        // if ($param['nobpjs'] != '' && $param['nobpjs'] != null) { // jika pasien bpjs
        //     $pasien = SMIS_Pasien::where("nobpjs", $param['nobpjs'])->where('id', 'like', env('slug_klinik'))->first();
        //     if (is_null($pasien)) {
        //         $pasien = Mjkn_Patient::where('nobpjs', $param['nobpjs'])->first();
        //     }
        // } else { // jika pasien non bpjs
        //     $pasien = SMIS_Pasien::where("ktp", $param['ktp'])->where('id', 'like', env('slug_klinik'))->first();
        //     if (is_null($pasien)) {
        //         $pasien = Mjkn_Patient::where('nik', $param['ktp'])->first();
        //     }
        // }
        // dd($param);
        if (is_null($pasien)) {
            return $this->responseFormat("Data Pasien tidak ditemukan, silahkan daftar baru.", 202);
        }

        // last antrian
        $lastAntrian = Antrian::where(['jadwal_id' => $jadwal->id, 'tanggalperiksa' => $param['tanggalperiksa']])->orderBy("id", "desc")->first();
        // sisa antrian jkn
        if (!is_null($lastAntrian))
            $sisakuota = $lastAntrian->sisakuota - 1;
        else
            $sisakuota = $jadwal->kuota;
        if ($sisakuota < 0) { // jika kuota jkn habis
            return $this->responseFormat("Sisa kuota sudah habis.", 201);
        }

        // jika sudah ambil antrian
        if (!is_null(Antrian::where(['jadwal_id' => $jadwal->id, 'tanggalperiksa' => $param['tanggalperiksa']])->where("id_pasien", $pasien->id)->where('taskid', '!=', 99)->first()))
            return $this->responseFormat("Anda telah mengambil Antrian di poli ini untuk tanggal " . $param['tanggalperiksa'], 201);
        // jika validasi sudah benar
        return $this->responseFormat("ok", 200, ["jadwal" => $jadwal, "sisakuota" => $sisakuota, "pasien" => $pasien]);
    }
}
