<?php

namespace App\Http\Controllers\DataIndukPendaftaran;

use App\Http\Controllers\Controller;
use App\Services\DataIndukPendaftaranService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class PerusahaanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.perusahaan', [
            'role' => 'perusahaan',
            'data' => $dataIndukPendaftaranService->getData('smis_rg_perusahaan')->paginate(10),
            'keyword' => ''
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $store = $dataIndukPendaftaranService->createPerusahaan($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Master Perusahaan berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('perusahaan.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getDataById($id, 'smis_rg_perusahaan'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $update = $dataIndukPendaftaranService->updatePerusahaan($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Perusahaan berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('perusahaan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $delete = $dataIndukPendaftaranService->deleteData($id, 'smis_rg_perusahaan');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Perusahaan berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('perusahaan.index');
    }

    public function search(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.perusahaan', [
            'role' => 'perusahaan',
            'data' => $dataIndukPendaftaranService->getSearchPerusahaan($request)->paginate(10),
            'keyword' => $request->keyword
        ]);
    }

    public function download(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('data_induk_pendaftaran.pdf_perusahaan', [
            'data' => $dataIndukPendaftaranService->getSearchPerusahaan($request)->get()
        ])->setPaper('a4', 'portrait');
        return $pdf->download('Perusahaan.pdf');
    }
}
