<?php

namespace App\Http\Controllers\DataIndukKepegawaian;

use App\Exports\DataIndukKepegawaian\PendidikanExport;
use App\Http\Controllers\Controller;
use App\Services\DataIndukKepegawaianService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;

class PendidikanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.pendidikan', [
            'role' => 'pendidikan',
            'keyword' => '',
            'data' => $dataIndukKepegawaianService->getData('smis_hrd_pendidikan')->paginate(10)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        //dd($request->all());
        $store = $dataIndukKepegawaianService->createPendidikan($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Pendidikan berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('pendidikan.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return response()->json($dataIndukKepegawaianService->getDataById($id, 'smis_hrd_pendidikan'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $update = $dataIndukKepegawaianService->updatePendidikan($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Pendidikan berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('pendidikan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $delete = $dataIndukKepegawaianService->deleteData($id, 'smis_hrd_pendidikan');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Status Pendidikan berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('pendidikan.index');
    }

    public function search(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.pendidikan', [
            'data' => $dataIndukKepegawaianService->getSearchPendidikan($request)->paginate(10),
            'keyword' => $request->keyword,
            'role' => 'pendidikan'
        ]);
    }

    public function download(Request $request)
    {
        return Excel::download(new PendidikanExport($request), 'Data_Induk_Pendidikan.xlsx');
    }
}
