<?php

namespace App\Http\Controllers\DataIndukKepegawaian;

use App\Exports\DataIndukKepegawaian\GolonganExport;
use App\Http\Controllers\Controller;
use App\Services\DataIndukKepegawaianService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;

class GolonganController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.golongan', [
            'role' => 'golongan',
            'keyword' => '',
            'data' => $dataIndukKepegawaianService->getData('smis_hrd_golongan')->paginate(10)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $store = $dataIndukKepegawaianService->createGolongan($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Golongan berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('golongan.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return response()->json($dataIndukKepegawaianService->getDataById($id, 'smis_hrd_golongan'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $update = $dataIndukKepegawaianService->updateGolongan($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Golongan berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('golongan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $delete = $dataIndukKepegawaianService->deleteData($id, 'smis_hrd_golongan');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Golongan berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('golongan.index');
    }

    public function search(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.golongan', [
            'data' => $dataIndukKepegawaianService->getSearchGolongan($request)->paginate(10),
            'keyword' => $request->keyword,
            'role' => 'golongan'
        ]);
    }

    public function download(Request $request)
    {
        return Excel::download(new GolonganExport($request), 'Data_Induk_Golongan.xlsx');
    }
}
