<?php

namespace App\Exports;

use App\Services\JasaDokterBpjsService;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Sheet;

class JasaDokterBpjsExport implements FromView, WithEvents
{
    private $param;

    /**
     * @param $param
     */
    public function __construct($param)
    {
        $this->param = $param;
    }


    public function view(): View
    {
        $jasaDokterBpjsService = new JasaDokterBpjsService();

        return view('jasa_dokter_bpjs.excel', [
            'tanggal_dari' => $this->param->tanggal_dari_conv,
            'tanggal_sampai' => $this->param->tanggal_sampai_conv,
            'req_nama_dokter' => $this->param->nama_dokter,
            'data_operator' => $jasaDokterBpjsService->getDataByFilter($this->param, "operator")->get(),
            'data_referal' => $jasaDokterBpjsService->getDataByFilter($this->param, "referal")->get(),
        ]);
    }

    public function registerEvents(): array
    {
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });
        return [
            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getColumnDimension('A')->setWidth(15);
                $event->sheet->getColumnDimension('B')->setWidth(15);
                $event->sheet->getColumnDimension('C')->setWidth(15);
                $event->sheet->getColumnDimension('D')->setWidth(15);
                $event->sheet->getColumnDimension('E')->setWidth(18);
                $event->sheet->getColumnDimension('F')->setWidth(15);
                $event->sheet->getColumnDimension('G')->setWidth(15);

                $event->sheet->getStyle('F:G')->getNumberFormat()
                    ->setFormatCode('_(* #,##0_);_(* \(#,##0\);_(* "-"??_);_(@_)');
            },

        ];
    }
}
