<?php

namespace App\Http\Controllers\Api\Wsrs;

use App\Http\Controllers\Controller;
use App\Models\TokenAntreanFktp;
use Illuminate\Http\Request;
use Carbon\Carbon;

class Token extends Controller
{
    const TOKEN           = "RS_BPJS_INOVASI_IDE_UTAMA";
    function index(Request $req)
    {
        $username = $req->header("x-username");
        $password = $req->header("x-password");
        $user = TokenAntreanFktp::where(["username" => $username, "password" => $password])->first();

        if (!is_null($user)) {
            $date = Carbon::now();
            $data = str_shuffle(self::TOKEN) . $date->format('Y-m-d h:i:s');
            $user->token = hash("sha256", $data);
            $user->expired = $date->addHour();
            $user->save();

            $token = [
                "token" => $user->token
            ];
            return [
                "response" => $token,
                "metadata" => [
                    "message" => "Ok",
                    "code" => 200
                ]
            ];
        } else {
            return [
                "metadata" => [
                    "message" => "Username atau password salah.",
                    "code" => 201
                ]
            ];
        }
    }
}
