<?php

namespace App\Http\Controllers\Api\Wsrs;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Antrian;
use App\Models\Smis_Jadwalpoli;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class SisaAntrian extends Controller
{
	private $nobpjs;
	private $kode;
	private $tanggalperiksa;

	public function index($bpjs, $kode, $tanggal)
	{
		$this->nobpjs = $bpjs ? $bpjs : "";
		$this->kode = $kode ? $kode : "";
		$this->tanggalperiksa = $tanggal ? $tanggal : "";

		$valid = $this->valid();

		if ($valid['metadata']['code'] != "200") return $valid;

		$jadwal = $valid['response']['jadwal'];

		$antrian = Antrian::getjadwal($jadwal->id, $tanggal)->where('nobpjs', $bpjs)->orderBy("id", "desc");

		if (is_null($antrian->first())) {
			return $this->responseFormat("Antrian tidak ditemukan", 201);
		}

		$my_antrian = $antrian->first();

		$totalantrean = Antrian::where('jadwal_id', $jadwal['id'])->where('taskid', '<>', 99)->where('unit_kerja', env('NAMA_KLINIK'))->count();
		$antreanpanggil = Antrian::where('jadwal_id', $jadwal['id'])->where('tanggalperiksa', $tanggal)->where('taskid', 4)->orderBy('id', 'desc')->first();

		return $this->responseFormat("Ok", 200, [
			"namapoli" => $jadwal->nama_poli,
			"totalantrean" => (string)$totalantrean,
			"sisaantrean" => (string) ($antreanpanggil ? $my_antrian->angkaantrean - $antreanpanggil->angkaantrean : $my_antrian->angkaantrean),
			"antreanpanggil" => $antreanpanggil ? $antreanpanggil->nomorantrean : "",
			"keterangan" => $antrian->value("keterangan") ? $antrian->value("keterangan") : ""
		]);
	}

	private function valid()
	{
		$jadwal = new Smis_Jadwalpoli();
		// jika poli tidak ada
		$jadwal = $jadwal->where("kodepoli_bpjs", $this->kode);
		if (is_null($jadwal->first())) {
			return $this->responseFormat("Poli tidak ditemukan.", 201);
		}
		// jika format tanggal salah
		$checkTgl = Validator::make(["tanggalperiksa" => $this->tanggalperiksa], [
			'tanggalperiksa' => 'date_format:Y-m-d',
		]);

		if ($checkTgl->fails()) {
			return $this->responseFormat("Format tanggal salah gunakan format Y-m-d.", 201);
		}

		$antrian = Antrian::where('nobpjs', $this->nobpjs)->where('tanggalperiksa', $this->tanggalperiksa)->first();

		$hari = Carbon::createFromFormat("Y-m-d", $this->tanggalperiksa)->dayOfWeek;
		$jadwal = $jadwal->where("hari", $hari)->where('slug_poli', 'like', '%'.env('slug_klinik').'%')->where('id', $antrian->jadwal_id)->first();
		
		if (is_null($jadwal)) {
			return $this->responseFormat("Jadwal tidak ditemukan.", 201);
		}
		
		// jika validasi sudah benar
		return $this->responseFormat("ok", 200, ["jadwal" => $jadwal]);
	}
}
