<?php

namespace App\Http\Controllers\Api\Wsbpjs;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;

class BpjsService extends Controller
{

    public $credential;
    private $timeStamp;
    private $signature;

    function __construct()
    {
        date_default_timezone_set('UTC');
        $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));

        $cred = DB::table('rs_credentials')->where('slug_klinik', env('slug_klinik'))->where('layanan', 'antrian')->first();

        if ($cred == null) {
            return null;
        }

        $this->timeStamp = $timeStamp;
        $this->credential = $cred;
        $this->signature = $this->signature();
    }

    function get($url){
        $guzzleClient = new Client([
            'verify' => false
        ]);

        $response = $guzzleClient->request('get', $this->credential->base_url . '/' . $url, [
            'headers' => [
                'x-cons-id'     => $this->credential->cons_id,
                'x-timestamp'  => $this->timeStamp,
                'x-signature'   => $this->signature,
                'user_key' => $this->credential->user_key,
            ]
        ])->getBody()->getContents();

        return $this->decriptResponse($response);
    }

    function post($data,$url)
    {
        $guzzleClient = new Client([
            'verify' => false
        ]);
        
        $response = $guzzleClient->request('post', $this->credential->base_url . '/' . $url, [
            'headers' => [
                'x-cons-id'     => $this->credential->cons_id,
                'x-timestamp'  => $this->timeStamp,
                'x-signature'   => $this->signature,
                'user_key' => $this->credential->user_key,
            ],
            'body' => $data
        ])->getBody()->getContents();
        
        return $response;
    }

    function signature(){
        $signature = hash_hmac('sha256', $this->credential->cons_id . "&" . $this->timeStamp, $this->credential->cons_secret, true);
        return base64_encode($signature);
    }

    public function decriptResponse($data)
    {   
        $resp =  json_decode($data);
        if (is_null($resp) || $resp->metadata->code > 200) {
            return $data;
        } else {
            $data =  json_decode($data);
            $response = $data->response;
            $d = $this->stringDecrypt($response);
            $e = $this->decompress($d);
            $data->response = json_decode($e);
            return json_encode($data);
        }
    }

    protected function stringDecrypt($string){  
        $key = $this->credential->cons_id.$this->credential->cons_secret.$this->timeStamp;
      
        $encrypt_method = 'AES-256-CBC';

        // hash
        $key_hash = hex2bin(hash('sha256', $key));
        
        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hex2bin(hash('sha256', $key)), 0, 16);

        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key_hash, OPENSSL_RAW_DATA, $iv);
  
        return $output;
    }

    protected function decompress($string){
        return \LZCompressor\LZString::decompressFromEncodedURIComponent($string);
    }
}
