<?php

namespace App\Http\Controllers\Api\Wsrs;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Models\Antrian;

class BatalAntrian extends Controller
{
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "nomorkartu"  => "required",
            "kodepoli"   => "required",
            "tanggalperiksa"   => "required|date:Y-m-d",
            // "keterangan"   => "required",
        ], [
            "nomorkartu.required"  => "Nomor Kartu Harus Diisi",
            "kodepoli.required"  => "Kode Poli Harus Diisi",
            "tanggalperiksa.required"  => "Tanggal Periksa Harus Diisi",
            "tanggalperiksa.date"  => "Tanggal Periksa Tidak Valid",
            // "keterangan.required"  => "Keterangan Harus Diisi",
        ]);
        if ($validator->fails()) {
            return  $this->responseFormat($validator->errors()->first(), 201);
        } else {
            $cekKodeBooking = Antrian::where('nobpjs', $request->nomorkartu)->where('tanggalperiksa', $request->tanggalperiksa)->orderBy('id', 'desc')->first();

            if (is_null($cekKodeBooking)) {
                return  $this->responseFormat('Antrean Tidak Ditemukan', 201);
            }

            if ($cekKodeBooking->taskid == 99) {
                return  $this->responseFormat('Antrean Tidak Ditemukan atau Sudah Dibatalkan', 201);
            }

            if ($cekKodeBooking->taskid != 3 && $cekKodeBooking->taskid != 1 && $cekKodeBooking->taskid != 0) {
                return  $this->responseFormat('Pasien Sudah Dilayani Antrean Tidak Dapat Dibatalkan', 201);
            }

            Antrian::where('nobpjs', $request->nomorkartu)->where('tanggalperiksa', $request->tanggalperiksa)->update([
                'taskid' => '99',
                'updated_at' => now(),
                'keterangan' => '',
                'response_code' => 200,
                'response_message' => 'Ok'
            ]);
            return $this->responseFormat('Ok', 200);
        }
    }
}
