<?php

namespace App\Http\Controllers\Api\Wsrs;

use App\Http\Controllers\Controller;
use App\Models\Antrian;
use App\Models\MjknPatientFktp;
use App\Models\Smis_Jadwalpoli;
use App\Models\Smis_Rg_Patient;
use App\Models\Smis_Setting_Id_Asuransi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Helpers\GeneralHelper as GH;
use DateTime;

class AmbilAntrian extends Controller
{
	public function __construct(Request $request)
	{
		$this->nobpjs = $request->input("nomorkartu", "");
		$this->nik = $request->input("nik", "");
		$this->kodepoli = $request->input("kodepoli", "");
		$this->tanggalperiksa = $request->input("tanggalperiksa", "");
		$this->keluhan = $request->input("keluhan", "");
		$this->kodedokter = $request->input("kodedokter", "");
		$this->jampraktek = $request->input("jampraktek", "");
		$this->norm = $request->input("norm", "");
		$this->nohp = $request->input("nohp", "");
	}

	public function index(Request $request)
	{
		// validasi
		$valid = $this->valid();
		if ($valid['metadata']['code'] != "200") return $valid;

		// data antrian
		$req = $request->all();
		$jadwal = $valid['response']['jadwal'];
		$pasien = $valid['response']['pasien'];

		// if ($pasien->origin_updated == 'mobile-jkn') {
		// 	return $this->responseFormat('No. rekam medis anda ' . $pasien['nrm'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di Klinik Al Aziz', 201);
		// }

		$sisakuota = $valid['response']['sisakuota'];
		$generate = GH::generateAntrean($jadwal['kodedokter_bpjs'], $jadwal['id'], $req['kodepoli'], $req['tanggalperiksa']);
		$mili = strtotime($req['tanggalperiksa'] . ' ' . $jadwal->jam_mulai);
		$estimasi = ($mili * 1000) + (($generate['angkaantrean'] - 1) * ($jadwal->estimasi_layanan * 60000));

		$tgl_pasien = date('Y-m-d', strtotime($pasien['tanggal']));
		$now = date('Y-m-d');

		// create new antrian
		$antrian = new Antrian();
		if ($tgl_pasien != $now) {
			$antrian->pasien_baru = 0;
		} else {
			$antrian->pasien_baru = 1;
		}

		$asuransi = Smis_Setting_Id_Asuransi::first();

		$antrian->taskid = 0;
		$antrian->source = 1;
		$antrian->jenis_kunjungan = 'Kunjungan Sakit';
		$antrian->nobpjs = $pasien['nobpjs'];
		$antrian->keluhan = $req['keluhan'];
		$antrian->tanggalperiksa = $req['tanggalperiksa'];
		$antrian->jadwal_id = $jadwal['id'];
		$antrian->asuransi = $asuransi ? $asuransi->id_asuransi : 0;
		$antrian->nomorantrean = $generate['nomorantrean'];
		$antrian->angkaantrean = $generate['angkaantrean'];
		$antrian->norm = $pasien['nrm'];
		$antrian->nama_pasien = $pasien['nama'];
		$antrian->id_pasien = $pasien['id'];
		$antrian->carabayar = 'bpjs';
		$antrian->namapoli = $jadwal['nama_poli'];
		$antrian->namadokter = $jadwal['nama_dokter'];
		$antrian->estimasidilayani = $estimasi; // masih salah harus di ganti
		$antrian->sisakuota = $sisakuota;
		$antrian->kuota = $jadwal['kuota'];
		$antrian->keterangan = 'Apabila antrean terlewat harap mengambil antrean kembali.';
		$antrian->perusahaan = 0;
		$antrian->unit_kerja = env('NAMA_KLINIK');

		$antrean_panggil = Antrian::where('jadwal_id', $jadwal['id'])->where('tanggalperiksa', $req['tanggalperiksa'])->where('taskid', 4)->orderBy('id', 'desc')->first();
		$sisa = Antrian::where('jadwal_id', $jadwal['id'])->where('tanggalperiksa', $req['tanggalperiksa'])
			->where('taskid', '<', 4)->count();

		$antrian->response_code = 200;
		$antrian->response_message = 'Ok';
		$antrian->save();
		return $this->responseFormat('Ok', 200, [
			'nomorantrean' => $antrian->nomorantrean,
			'angkaantrean' => (string) $antrian->angkaantrean,
			'namapoli' => $antrian->namapoli,
			'sisaantrean' => (string) $sisa,
			'antreanpanggil' => $antrean_panggil ? $antrean_panggil->nomorantrean : '',
			'keterangan' => $antrian->keterangan,
		]);
	}

	private function valid()
	{
		if ($this->nobpjs == '') {
			return $this->responseFormat("Nomor Kartu Tidak Boleh Kosong.", 201);
		}

		if ($this->nik == '') {
			return $this->responseFormat("NIK Tidak Boleh Kosong.", 201);
		}

		if ($this->kodepoli == '') {
			return $this->responseFormat("Kode Poli Tidak Boleh Kosong.", 201);
		}

		if ($this->tanggalperiksa == '') {
			return $this->responseFormat("Tanggal Periksa Tidak Boleh Kosong.", 201);
		}

		if (strlen($this->nobpjs) != 13) {
			return $this->responseFormat("Format Nomor Kartu Tidak Sesuai.", 201);
		}

		if (preg_match('#[^0-9]#',$this->nobpjs)) {
			return $this->responseFormat("Format Nomor Kartu Tidak Sesuai.", 201);
		}

		if (strlen($this->nik) != 16) {
			return $this->responseFormat("Format NIK Tidak Sesuai.", 201);
		}

		if (preg_match('#[^0-9]#',$this->nik)) {
			return $this->responseFormat("Format NIK Tidak Sesuai.", 201);
		}

		$jadwal = new Smis_Jadwalpoli();
		// jika poli tidak ada
		$jadwal = $jadwal->where("kodepoli_bpjs", $this->kodepoli);
		if (is_null($jadwal->first())) {
			return $this->responseFormat("Poli tidak ditemukan.", 201);
		}

		// jika format tanggal salah
		$checkTgl = Validator::make(["tanggalperiksa" => $this->tanggalperiksa], [
			'tanggalperiksa' => 'date_format:Y-m-d',
		]);
		if ($checkTgl->fails()) {
			return $this->responseFormat("Format tanggal salah gunakan format Y-m-d.", 201);
		}
		// jika tanggal telah berlalu
		if (date("Y-m-d") > $this->tanggalperiksa) {
			return $this->responseFormat("Tanggal periksa yang anda masukkan telah berlalu.", 201);
		}

		// jika data pasien tidak ada
		if ($this->nobpjs != '' && $this->nobpjs != null) { // jika pasien bpjs
			$pasien = Smis_Rg_Patient::where("nobpjs", $this->nobpjs)->where('id', 'like', '%'.env('slug_klinik').'%')->where('prop', '')->first();
			// if (is_null($pasien)) {
			// 	$pasien = MjknPatientFktp::where('nobpjs', $this->nobpjs)->first();
			// }
		} else { // jika pasien non bpjs
			$pasien = Smis_Rg_Patient::where("ktp", $this->nik)->where('id', 'like', '%'.env('slug_klinik').'%')->where('prop', '')->first();
			// if (is_null($pasien)) {
			// 	$pasien = MjknPatientFktp::where('nik', $this->nik)->first();
			// }
		}

		if (is_null($pasien)) {
			return $this->responseFormat("Data Pasien tidak ditemukan, silahkan daftar baru.", 202);
		}

		$hari = Carbon::createFromFormat("Y-m-d", $this->tanggalperiksa)->dayOfWeek;
		$jadwal = $jadwal->where("hari", $hari == 0 ? 7 : $hari)->where('slug_poli', 'like', '%'.env('slug_klinik').'%');

		$jampraktek = explode('-', $this->jampraktek);

		$jadwal = $jadwal->where('kodedokter_bpjs', $this->kodedokter)->where('jam_mulai', $jampraktek[0])->where('jam_selesai', $jampraktek[1])->where('prop','');


		if (is_null($jadwal->first())) {
			return $this->responseFormat("Jadwal Belum Tersedia, Silahkan Pilih Tanggal Lainnya", 201);
		}

		$jadwal = $jadwal->first();

		// if($jadwal->libur == 1){
		// 	return $this->responseFormat("Pendaftaran ke Poli ini Sedang Tutup.", 201);
		// }
		
		$hari_sekarang = Carbon::createFromFormat("Y-m-d", date('Y-m-d', strtotime('+7 hours')))->dayOfWeek;
		if (date('Y-m-d', strtotime('+7 hours')) == date('Y-m-d', strtotime($this->tanggalperiksa))) {
			$jadwal_selesai = date("H:i", strtotime($jadwal->jam_selesai));
			if (date("H:i", strtotime('+7 hours')) > $jadwal_selesai) {
				return $this->responseFormat("Pendaftaran ke poli " . $jadwal->nama_poli . " sudah tutup jam " . $jadwal->jam_selesai, 201);
			}
		}

		$date1 = new DateTime($this->tanggalperiksa);
		$date2 = new DateTime(date('Y-m-d'));
		$interval = $date1->diff($date2);

		if($interval->days > 1){
			return $this->responseFormat("Pendaftaran hanya dapat dilakukan minimal H-1.", 201);
		}

		// if (date('H:i', strtotime('+7 hours')) > date('H:i', strtotime($jadwal->jam_selesai)) ){
		// 	return $this->responseFormat("Pendaftaran ke Poli".$jadwal->namapoli." Sudah Tutup Jam ".$jadwal->jam_selesai.".", 201);
		// }

		// last antrian
		$lastAntrian = Antrian::where(['jadwal_id' => $jadwal->id, 'tanggalperiksa' => $this->tanggalperiksa])->orderBy("id", "desc");

		if ($lastAntrian->value('sisakuota')) {
			if (($lastAntrian->value('sisakuota') - 1) <= 0) {
				return $this->responseFormat("Sisa kuota sudah habis.", 201);
			}
			$sisakuota = $lastAntrian->value('sisakuota') - 1;
		} else {
			$sisakuota = $jadwal->kuota - 1;
		}

		// jika sudah ambil antrian
		if (!is_null($lastAntrian->where("id_pasien", $pasien->id)->where('taskid', '!=', 99)->first()))
			return $this->responseFormat("Anda telah mengambil Antrian di poli ini untuk tanggal " . $this->tanggalperiksa, 201);
		// jika validasi sudah benar
		return $this->responseFormat("ok", 200, ["jadwal" => $jadwal, "sisakuota" => $sisakuota, "pasien" => $pasien]);
	}
}
