<?php

namespace App\Http\Controllers\Api\Wsbpjs;

use App\Http\Controllers\Controller;

class ReferensiDokter extends Controller
{
    function index($poli,$tanggal)
    {
        try {
            $bpjs = new BpjsService();
            
            if ($bpjs->credential == null) {
                return $this->responseFormat('Credential tidak ditemukan', 404);
            }

            $response = $bpjs->get('ref/dokter/kodepoli/'.$poli.'/tanggal/'.$tanggal);
            $result = json_decode($response);
            return $this->responseFormat('Ok', 1, ['list' => $result->response]);
        } catch (\Throwable $th) {
            return $this->responseFormat($th->getMessage(), 500);
        }
    }
}
