<?php

use App\Http\Controllers\Api\Wsbpjs\BatalAntrean;
use App\Http\Controllers\Api\Wsbpjs\ReferensiDokter;
use App\Http\Controllers\Api\Wsrs\AmbilAntrian;
use App\Http\Controllers\Api\Wsrs\BatalAntrian;
use App\Http\Controllers\Api\Wsrs\PasienBaru;
use App\Http\Controllers\Api\Wsrs\SisaAntrian;
use App\Http\Controllers\Api\Wsrs\StatusAntrian;
use App\Http\Controllers\Api\Wsrs\Token;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Wsbpjs\ReferensiPoli;
use App\Http\Controllers\Api\Wsbpjs\TambahAntrean;
use App\Http\Controllers\Api\Wsbpjs\UpdateStatus;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'wsfktp'], function () {
    Route::get('auth', [Token::class, 'index']);
    Route::group(['middleware' => 'wsrs'], function () {
        Route::post('peserta', [PasienBaru::class, 'index']);
        Route::post('antrean', [AmbilAntrian::class, 'index']);
        Route::get('antrean/status/{kode}/{tanggal}', [StatusAntrian::class, 'index']);
        Route::get('antrean/sisapeserta/{bpjs}/{kode}/{tanggal}', [SisaAntrian::class, 'index']);
        Route::put('antrean/batal', [BatalAntrian::class, 'index']);
    });
});

Route::group(['prefix' => 'wsbpjs'], function () {
    Route::get('ref/poli/tanggal/{tanggal}', [ReferensiPoli::class, 'index']);
    Route::get('ref/dokter/kodepoli/{poli}/tanggal/{tanggal}', [ReferensiDokter::class, 'index']);
    Route::post('antrean/add', [TambahAntrean::class, 'index']);
    Route::post('antrean/panggil', [UpdateStatus::class, 'index']);
    Route::post('antrean/batal', [BatalAntrean::class, 'index']);
});
