<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAntriansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('antrians', function (Blueprint $table) {
            $table->id();
            $table->string('noreg', 32)->default('');
            $table->integer('pasien_baru');
            $table->string('carabayar', 64);
            $table->tinyInteger('jenis_obat')->unsigned()->nullable();
            $table->integer('asuransi');
            $table->integer('perusahaan');
            $table->string('waktu_checkin', 32)->nullable();
            $table->string('waktu_taskid_dua', 32)->nullable();
            $table->string('waktu_taskid_tiga', 32)->nullable();
            $table->string('waktu_taskid_empat', 32)->nullable();
            $table->string('waktu_taskid_lima', 32)->nullable();
            $table->string('waktu_taskid_enam', 32)->nullable();
            $table->string('waktu_taskid_tujuh', 32)->nullable();
            $table->string('response_code', 10)->nullable();
            $table->string('response_message')->nullable();
            $table->smallInteger('taskid');
            $table->bigInteger('jadwal_id');
            $table->date('tanggalperiksa');
            $table->string('nomorantrean', 20);
            $table->integer('angkaantrean');
            $table->integer('norm');
            $table->string('namapoli');
            $table->string('namadokter');
            $table->string('estimasidilayani');
            $table->integer('sisakuota');
            $table->integer('kuota');
            $table->text('keterangan');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}
