<?php

namespace App\Http\Controllers\Api\Wsrs;

use App\Models\Smis_Jadwalpoli;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Antrian;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class StatusAntrian extends Controller
{
	private $kodepoli = '';
	private $tanggalperiksa = '';

	public function index($kode, $tanggalperiksa)
	{
		if (strtotime($tanggalperiksa) < strtotime(date('Y-m-d'))) {
			return $this->responseFormat('Tanggal Periksa Tidak Berlaku', 201);
		}
		$this->kodepoli = $kode ? $kode : "";
		$this->tanggalperiksa = $tanggalperiksa ? $tanggalperiksa : "";
		// validasi
		$valid = $this->valid();
		if ($valid['metadata']['code'] != "200") return $valid;

		$jadwal = $valid['response']['jadwal'];

		$result = [];

		$schedule = Smis_Jadwalpoli::where('kodepoli_bpjs', $kode)->where('hari', $jadwal->hari)->where('slug_poli', 'like', '%'.env('slug_klinik').'%')->get();

		for ($i=0; $i < sizeof($schedule); $i++) { 
			$totalantrean = Antrian::where('jadwal_id', $schedule[$i]->id)
			->where('tanggalperiksa', $this->tanggalperiksa)
			->where('taskid', '<>', 99)
			->where('unit_kerja', env('NAMA_KLINIK'))->count();
			$antreanpanggil = Antrian::where('jadwal_id', $schedule[$i]->id)
			->where('tanggalperiksa', $this->tanggalperiksa)
			->where('taskid', 4)
			->where('unit_kerja', env('NAMA_KLINIK'))
			->orderBy('id', 'desc')->first();

			array_push($result, [
				"namapoli" => $schedule[$i]->nama_poli,
				"totalantrean" => (string) $totalantrean,
				"sisaantrean" => (string) $totalantrean - ($antreanpanggil ? $antreanpanggil->angkaantrean : 0),
				"antreanpanggil" => $antreanpanggil ? $antreanpanggil->nomorantrean : "-",
				"keterangan" => "",
				'kodedokter' => $schedule[$i]->kodedokter_bpjs,
				'nama_dokter' => $schedule[$i]->nama_dokter,
				'jampraktek' => $schedule[$i]->jam_mulai.'-'.$schedule[$i]->jam_selesai
			]);
		}

		return $this->responseFormat("Ok", 200, $result);

		// return $this->responseFormat("Ok", 200, [
		// 	"namapoli" => $jadwal->nama_poli,
		// 	"totalantrean" => (string) $totalantrean,
		// 	"sisaantrean" => (string) $totalantrean - sizeof($antreanpanggil),
		// 	"antreanpanggil" => sizeof($antreanpanggil) > 0 ? $antreanpanggil[0]->nomorantrean.'-'.$antreanpanggil[sizeof($antreanpanggil) - 1] : "-",
		// 	"keterangan" => "",
		// 	'kodedokter' => $jadwal->kodedokter_bpjs,
		// 	'nama_dokter' => $jadwal->nama_dokter,
		// 	'jampraktek' => $jadwal->jam_mulai.'-'.$jadwal->jam_selesai
		// ]);
	}

	private function valid()
	{
		$jadwal = new Smis_Jadwalpoli();
		// jika poli tidak ada
		$jadwal = $jadwal->where("kodepoli_bpjs", $this->kodepoli);
		if (is_null($jadwal->first())) {
			return $this->responseFormat("Poli tidak ditemukan.", 201);
		}
		// jika format tanggal salah
		$checkTgl = Validator::make(["tanggalperiksa" => $this->tanggalperiksa], [
			'tanggalperiksa' => 'date_format:Y-m-d',
		]);

		if ($checkTgl->fails()) {
			return $this->responseFormat("Format tanggal salah gunakan format Y-m-d.", 201);
		}

		$hari = Carbon::createFromFormat("Y-m-d", $this->tanggalperiksa)->dayOfWeek;
		$jadwal = $jadwal->where("hari", $hari)->first();
		if (is_null($jadwal)) {
			return $this->responseFormat("Jadwal tidak ditemukan.", 201);
		}

		// jika validasi sudah benar
		return $this->responseFormat("ok", 200, ["jadwal" => $jadwal]);
	}
}
