<?php

namespace App\Http\Controllers\Api\Wsrs;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Exceptions\ErrorValidation;
use App\Models\MjknPatientFktp;
use App\Models\Smis_Rg_Patient;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;

class PasienBaru extends Controller
{
	public function index(Request $request)
	{
		$req = $request->all();
		$this->valid($req);

		$arr = $this->dataPasien($req);

		$cek_nik_bpjs = Smis_Rg_Patient::where(function($q) use ($arr){
			$q->where('nobpjs', $arr['nobpjs'])->orWhere('ktp', $arr['ktp']);
		})->where('id', 'like', '%'.env('slug_klinik').'%')->where('prop', '')->first();
		
		if ($cek_nik_bpjs != null) {
			return $this->responseFormat("Data Peserta Sudah Pernah Dientrikan", 201);
		}

		DB::beginTransaction();

		$query = DB::table('smis_rg_patient')->insert($arr);
		$nrm = Smis_Rg_Patient::orderBy('id', 'desc')->first();
		$faskes = DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->first();

		DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->update([
			'last_nrm' => $arr['nrm']
		]);

		DB::table('smis_rg_history_nrm')->insert([
			'id_rg_patient' => $arr['id'],
			'operator' => 'Mobile JKN',
			'waktu' => date('Y-m-d H:i:s'),
			'deskripsi' => 'MOBILE JKN PASIEN BARU',
			'nrm_asal' => $faskes->last_nrm,
			'nrm_baru' => $arr['nrm'],
			'unit' => env('NAMA_KLINIK')
		]);

		DB::commit();

		// return $this->responseFormat("No. rekam medis anda " . $nrm->nrm . " tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di ".env('NAMA_KLINIK'),201,['norm' => $nrm->nrm]);
		return $this->responseFormat('OK', 200);
	}

	// validation data pasien
	public static function valid($req)
	{
		$valid = Validator::make($req, [
			"nik" => "required|digits:16",
			"nomorkk" => "required",
			"nomorkartu" => 'required',
			"nama" => "required",
			"jeniskelamin" => "required",
			"tanggallahir" => 'required|date_format:Y-m-d|before_or_equal:now',
			"alamat" => "required:unique,smis_rg_patient",
			"kodeprop" => "required",
			"namaprop" => "required",
			"kodedati2" => "required",
			"namadati2" => "required",
			"kodekec" => "required",
			"namakec" => "required",
			"namakel" => "required",
			"rw" => "required",
			"rt" => "required",
			"kodekel" => "required|numeric",
		], [
			'nik.required' => 'NIK Belum Diisi',
			'nik.digits' => 'Format NIK Tidak Sesuai',
			'nomorkk.required' => 'Nomor KK Belum Diisi',
			'nomorkartu.required' => 'Nomor Kartu Belum Diisi',
			'tanggallahir.required' => 'Tanggal Lahir Belum Diisi',
			'tanggallahir.date_format' => 'Format Tanggal Lahir Tidak Sesuai',
			'tanggallahir.before_or_equal' => 'Format Tanggal Lahir Tidak Sesuai',
			'nama.required' => 'Nama Belum Diisi',
			'jeniskelamin.required' => "Jenis Kelamin Belum Dipilih",
			'alamat.required' => 'Alamat Belum Diisi',
			'kodeprop.required' => 'Kode Propinsi Belum Diisi',
			'namaprop.required' => 'Nama Propinsi Belum Diisi',
			'kodedati2.required' => 'Kode Dati 2 Belum Diisi',
			'namadati2.required' => 'Dati 2 Belum Diisi',
			'kodekec.required' => 'Kode Kecamatan Belum Diisi',
			'namakec.required' => 'Kecamatan Belum Diisi',
			'kodekel.required' => 'Kode Kelurahan Belum Diisi',
			'kodekel.numeric' => 'Kode Kelurahan Harus Berupa Angka',
			'namakel.required' => 'Kelurahan Belum Diisi',
			'rt.required' => 'RT Belum Diisi',
			'rw.required' => 'RW Belum Diisi',
		]);
		if ($valid->fails()) {
			$errors = $valid->errors()->getMessages();
			$error_key = array_keys($valid->failed())[0];
			$error_message = $errors[$error_key][0];
			throw new ErrorValidation($error_message, 201);
		}

		if (strlen($req['nomorkartu']) != 13) {
			throw new ErrorValidation('Format Nomor Kartu Tidak Sesuai', 201);
		}

		$cek_nik_bpjs = Smis_Rg_Patient::where(function($q) use ($req){
			$q->where('nobpjs', $req['nomorkartu'])->orWhere('ktp', $req['nik']);
		})->where('id', 'like', '%'.env('slug_klinik').'%')->where('prop', '')->first();

		if ($cek_nik_bpjs != null) {
			throw new ErrorValidation('Data Peserta Sudah Pernah Dientrikan', 201);
		}
	}

	// get array data pasien
	public static function dataPasien($req)
	{

		$table_pasien = new Smis_Rg_Patient();
		$table_pasien = $table_pasien->getTable();

		$columns = Schema::getColumnListing($table_pasien);
		$dataArray = [];

		foreach ($columns as $column) {
			$type_column = Schema::getColumnType($table_pasien, $column);

			$default_input = "";
			if (in_array($type_column, ["integer", "boolean", "tinyint"])) $default_input = 0;
			if (in_array($type_column, ["date"])) $default_input = '0000-00-00';
			$dataArray[$column] = @$req[$column] ?? $default_input;
		}

		$last = Smis_Rg_Patient::select(DB::raw("MAX(REPLACE(id,'" . env('slug_klinik') . "','')*1) as id"), 'nrm')->where('id', 'like', env('slug_klinik') . '%')->first();
		// $last_nrm = Smis_Rg_Patient::select(DB::raw("MAX(nrm) as nrm"))->where('id', 'like', env('slug_klinik') . '%')->first();
		$last_nrm = DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->where('prop','')->first();

		$dataArray['id'] = !is_null($last) ? env('slug_klinik') . (string)((int)str_replace(env('slug_klinik'), '', $last->id) + 1) : env('slug_klinik') . (string)1;
		$dataArray['nobpjs'] = $req["nomorkartu"] ? $req['nomorkartu'] : "";
		$dataArray['ktp'] = $req["nik"];
		$dataArray['kelamin'] = $req['jeniskelamin'] == 'L';
		$dataArray['tgl_lahir'] = $req["tanggallahir"];
		$dataArray['alamat'] = $req["alamat"];
		$dataArray['provinsi'] = $req["kodeprop"];
		$dataArray['nama_provinsi'] = $req["namaprop"];
		$dataArray['kabupaten'] = $req["kodedati2"];
		$dataArray['nama_kabupaten'] = $req["namadati2"];
		$dataArray['kecamatan'] = $req["kodekec"];
		$dataArray['nama_kecamatan'] = $req["namakec"];
		$dataArray['kelurahan'] = $req["kodekel"];
		$dataArray['nama_kelurahan'] = $req["namakel"];
		$dataArray['rw'] = $req["rw"];
		$dataArray['rt'] = $req["rt"];
		$dataArray['nrm'] = $last_nrm ? (int)$last_nrm->last_nrm + 1 : 1;
		$dataArray['tanggal'] = Carbon::now();
		// $dataArray['origin_updated'] = 'mobile-jkn';
		$dataArray['ukerja'] = env('NAMA_KLINIK');
		$dataArray['faskes'] = env('NAMA_KLINIK');

		return $dataArray;
	}
}
