<?php

namespace App\Http\Controllers\Api\Wsbpjs;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TambahAntrean extends Controller
{

    function index(Request $req)
    {
        try {
            $bpjs = new BpjsService();

            $response = $bpjs->post(json_encode($req->all()), 'antrean/add');

            $result = json_decode($response);

            if ($result->metadata->code != 200) {
                return $result;
            }

            return $this->responseFormat('Ok', 200);
        } catch (\Throwable $th) {
            return $this->responseFormat($th->getMessage(), 500);
        }
    }
}
